/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class MNDigitField
extends JTextField {
    private static int currentLength = 0;
    private static int M;
    private static int N;
    private static ComponentActor MComponentActor;
    private static ComponentActor NComponentActor;

    public MNDigitField(int m, int n, JComponent mComp, JComponent nComp, int cols) {
        super(cols);
        M = m;
        N = n;
        MComponentActor = new ComponentActor(mComp);
        NComponentActor = new ComponentActor(nComp);
        MComponentActor.setActionType(0);
        NComponentActor.setActionType(0);
        this.getDocument().addDocumentListener(new MNDocumentListener());
    }

    public int howManyDigits() {
        return this.getText().length();
    }

    public void setM(int m) {
        M = m;
    }

    public int getM() {
        return M;
    }

    public void setN(int n) {
        N = n;
    }

    public int getN() {
        return N;
    }

    @Override
    protected Document createDefaultModel() {
        return new NDigitDocument();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        JButton button1 = new JButton("Button 1");
        JButton button2 = new JButton("Button 2");
        button1.setEnabled(false);
        button2.setEnabled(false);
        frame.setBackground(Color.white);
        frame.setLayout(new FlowLayout());
        frame.getContentPane().add(new MNDigitField(11, 12, button1, button2, 8));
        frame.getContentPane().add(button1);
        frame.getContentPane().add(button2);
        frame.pack();
        frame.setVisible(true);
    }

    class MNDocumentListener
    implements DocumentListener {
        MNDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.decide(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.decide(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public void decide(DocumentEvent e) {
            Document doc = e.getDocument();
            currentLength = doc.getLength();
            MComponentActor.decide(currentLength == M);
            NComponentActor.decide(currentLength == N);
        }
    }

    static class NDigitDocument
    extends PlainDocument {
        NDigitDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (currentLength + 1 > N) {
                return;
            }
            for (int i = 0; i < str.length(); ++i) {
                if (Character.isDigit(str.charAt(i))) continue;
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

