/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JFrame;

public class UPCField
extends MNDigitField {
    public UPCField(JButton MButton, JButton NButton) {
        super(11, 12, MButton, NButton, 8);
    }

    public void generateCheckDigit() {
        if (this.howManyDigits() == 11) {
            String upc = this.getText();
            int checksum = 0;
            checksum = this.generateCheckDigit(upc);
            this.setText(upc + checksum);
        }
    }

    public int generateCheckDigit(String upc) {
        int checksum = 0;
        for (int i = 1; i <= upc.length(); ++i) {
            if (i % 2 == 0) {
                checksum += this.charToInteger(upc.charAt(i - 1)) * 1;
                continue;
            }
            checksum += this.charToInteger(upc.charAt(i - 1)) * 3;
        }
        return (10 - checksum % 10) % 10;
    }

    public boolean isCheckDigitValid() {
        if (this.howManyDigits() == 12) {
            int validCheckDigit;
            String upc = this.getText();
            int checkDigitEntered = this.charToInteger(upc.charAt(11));
            return checkDigitEntered == (validCheckDigit = this.generateCheckDigit(upc.substring(0, 11)));
        }
        return false;
    }

    public int charToInteger(char c) {
        return c - 48;
    }

    public void setUPC(String upc) {
        this.setText(upc);
    }

    public String getUPC() {
        return this.getText();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("UPC-A Field");
        frame.setDefaultCloseOperation(3);
        JButton button1 = new JButton("Generate Check Digit");
        JButton button2 = new JButton("Generate Bar Code");
        button1.setEnabled(false);
        button2.setEnabled(false);
        frame.setBackground(Color.white);
        frame.setLayout(new FlowLayout());
        frame.getContentPane().add(new UPCField(button1, button2));
        frame.getContentPane().add(button1);
        frame.getContentPane().add(button2);
        frame.pack();
        frame.setVisible(true);
    }
}

