/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BarcodeLabel
extends JPanel {
    final String quiteZone = "000000000";
    final String leftStartCode = "101";
    final String rightEndCode = "101";
    final String centerCode = "01010";
    final String[] leftCodes = new String[]{"0001101", "0011001", "0010011", "0111101", "0100011", "0110001", "0101111", "0111011", "0110111", "0001011"};
    final String[] rightCodes = new String[]{"1110010", "1100110", "1101100", "1000010", "1011100", "1001110", "1010000", "1000100", "1001000", "1110100"};
    final int sliceNum = 113;
    String UPC;
    String barcode;
    boolean valid = false;
    Color barColor;
    Color spaceColor;
    Color errorColor;
    int x = 0;
    int sliceWidth;
    int width;
    int height;

    public BarcodeLabel(int sw, int sh, Color bc, Color sc, Color ec) {
        this.sliceWidth = sw;
        this.width = 113 * sw;
        this.height = sh;
        this.barColor = bc;
        this.spaceColor = sc;
        this.errorColor = ec;
        this.setBackground(this.spaceColor);
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    public void paintComponent(Graphics page) {
        super.paintComponent(page);
        page.setColor(this.getBackground());
        page.fillRect(0, 0, this.width, this.height);
        if (this.isValid()) {
            this.drawBarcode(page);
        }
    }

    public void drawBarcode(Graphics page) {
        this.x = 0;
        if (this.barcode != null) {
            int barcodeLength = this.barcode.length();
            for (int i = 0; i < barcodeLength; ++i) {
                if (this.barcode.charAt(i) == '0') {
                    page.setColor(this.spaceColor);
                } else if (this.barcode.charAt(i) == '1') {
                    page.setColor(this.barColor);
                } else {
                    page.setColor(this.errorColor);
                }
                this.x += this.sliceWidth;
                page.fillRect(this.x, 0, this.sliceWidth, this.height);
            }
        }
    }

    public void setUPC(String c) {
        this.UPC = c;
    }

    public String getUPC() {
        return this.UPC;
    }

    public void validateUPC() {
        this.valid = this.UPC.matches("[0-9]{12}?");
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean v) {
        this.valid = v;
        this.repaint();
    }

    public int charToInteger(char c) {
        return c - 48;
    }

    public void generateBarcode() {
        if (this.isValid()) {
            this.barcode = "000000000101" + this.leftCodes[this.charToInteger(this.UPC.charAt(0))] + this.leftCodes[this.charToInteger(this.UPC.charAt(1))] + this.leftCodes[this.charToInteger(this.UPC.charAt(2))] + this.leftCodes[this.charToInteger(this.UPC.charAt(3))] + this.leftCodes[this.charToInteger(this.UPC.charAt(4))] + this.leftCodes[this.charToInteger(this.UPC.charAt(5))] + "01010" + this.rightCodes[this.charToInteger(this.UPC.charAt(6))] + this.rightCodes[this.charToInteger(this.UPC.charAt(7))] + this.rightCodes[this.charToInteger(this.UPC.charAt(8))] + this.rightCodes[this.charToInteger(this.UPC.charAt(9))] + this.rightCodes[this.charToInteger(this.UPC.charAt(10))] + this.rightCodes[this.charToInteger(this.UPC.charAt(11))] + "101" + "000000000";
            this.repaint();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        BarcodeLabel barcodeLabel = new BarcodeLabel(4, 200, Color.blue, Color.yellow, Color.red);
        barcodeLabel.setUPC("314159265358");
        barcodeLabel.validateUPC();
        barcodeLabel.generateBarcode();
        frame.setBackground(Color.white);
        frame.getContentPane().add(barcodeLabel);
        frame.pack();
        frame.setVisible(true);
    }
}

